#include <iostream>
#include <set>
#include <map>
#define _USE_MATH_DEFINES
#include <cmath>
#include <algorithm>
#include <unordered_map>
#include <unordered_set>
#include <vector>
#include <ctime>
#include <random>

using namespace std;

using ll = long long;
using ld = long double;
using vll = vector<ll>;
using vvll = vector<vll>;
using pll = pair<ll, ll>;
using vpll = vector<pll>;

ll INF = 1e18;
ld EPS = 1e-9;

ll MOD = 1e9 + 7;
ll P = 239;
ll B = 350;

minstd_rand generator;

ll gcd(ll a, ll b) {
    while (b > 0) {
        a %= b;
        swap(a, b);
    }

    return a;
}

int main() {
#ifdef LOCAL
    freopen("inp.txt", "r", stdin);
    freopen("out.txt", "w", stdout);

    clock_t timer = clock();
#else
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    cout.precision(64);
    cout << fixed;
#endif

    ll t;
    cin >> t;

    while (t--) {
        ll x, y;
        cin >> x >> y;

        ll d = y - x;

        ll mn = INF;

        if (gcd(x, y) == x) {
            cout << 0 << "\n";
            continue;
        }

        for (ll i = 1; i * i <= d; i++) {
            if (d % i) continue;

            {
                ll k = x - i;
                if (k >= 0 && gcd(x - k, y - k) == x - k) {
                    mn = min(mn, k);
                }
            }

            {
                ll k = x - d / i;
                if (k >= 0 && gcd(x - k, y - k) == x - k) {
                    mn = min(mn, k);
                }
            }
        }

        cout << mn << "\n";
    }

#ifdef LOCAL
    cout << "\nExecution time: " << (ld)(clock() - timer) / CLOCKS_PER_SEC;
#endif
}
